<?php
/**
 * این فایل فقط آرایه‌های کیبورد و تابع تولید منوی اصلی را نگه می‌دارد.
 * در فایل اصلی (index.php) با `require_once` آن را فراخوانی می‌کنیم.
 */

/**
 * کیبورد منوی اصلی را بر اساس ادمین یا کاربر بودن می‌سازد.
 */
function get_main_keyboard($is_admin = false) {
    $buttons = [
        ['📱 شبکه های اجتماعی', '📝 درباره من'],
        ['📝 درخواست مشاوره']
    ];
    
    if($is_admin) {
        array_unshift($buttons, ['👥 دریافت لیست شرکت کنندگان', '📢 مدیریت اطلاعیه‌ها']);
    }
    
    return [
        'keyboard' => $buttons,
        'resize_keyboard' => true
    ];
}

$keyboards = [
    'social' => [
        'keyboard' => [
            ['اینستاگرام', 'تلگرام'],
            ['یوتیوب', 'سایت'],
            ['🔙 بازگشت']
        ],
        'resize_keyboard' => true
    ],
    
    'back' => [
        'keyboard' => [
            ['🔙 بازگشت']
        ],
        'resize_keyboard' => true
    ],
    
    'admin_announce' => [
        'keyboard' => [
            ['📢 ارسال اطلاعیه', '📋 لیست اطلاعیه‌ها'],
            ['🔙 بازگشت به منوی اصلی']
        ],
        'resize_keyboard' => true
    ],
    
    'confirm' => [
        'keyboard' => [
            ['✅ تأیید و ارسال', '❌ لغو ارسال']
        ],
        'resize_keyboard' => true
    ]
];
