<?php
require_once __DIR__ . '/config.php'; // برای استفاده از $website, ...
require_once __DIR__ . '/db.php';     // برای استفاده از $pdo
require_once __DIR__ . '/keyboards.php'; // برای دسترسی به $keyboards و...
//شمسی
function gregorian_to_jalali($gy, $gm, $gd, $mod = '') {
    $g_d_m = [0,31,28,31,30,31,30,31,31,30,31,30,31];
    if($gy > 1600){
        $jy = 979;
        $gy -= 1600;
    } else {
        $jy = 0;
        $gy -= 621;
    }
    $gy2 = ($gm > 2)?($gy + 1):$gy;
    $days = (365 * $gy) + ((int)(($gy2 + 3) / 4)) - ((int)(($gy2 + 99) / 100)) + ((int)(($gy2 + 399) / 400)) - 80 + $gd + array_sum(array_slice($g_d_m, 0, $gm));
    $jy += 33 * ((int)($days / 12053)); 
    $days %= 12053;
    $jy += 4 * ((int)($days / 1461));
    $days %= 1461;
    if($days > 365) {
        $jy += (int)(($days - 1) / 365);
        $days = ($days - 1) % 365;
    }
    $jm = ($days < 186)?1 + (int)($days / 31):7 + (int)(($days - 186) / 30);
    $jd = 1 + (($days < 186)?($days % 31):(($days - 186) % 30));
    return ($mod === '') ? [$jy, $jm, $jd] : $jy . $mod . str_pad($jm, 2, '0', STR_PAD_LEFT) . $mod . str_pad($jd, 2, '0', STR_PAD_LEFT);
}

/**
 * تبدیل کامل رشته تاریخ میلادی به شمسی با زمان
 */
function to_jalali_datetime($datetime, $withTime = true) {
    $timestamp = strtotime($datetime);
    $gy = (int) date('Y', $timestamp);
    $gm = (int) date('n', $timestamp);
    $gd = (int) date('j', $timestamp);
    list($jy, $jm, $jd) = gregorian_to_jalali($gy, $gm, $gd);
    $date_part = "$jy/" . str_pad($jm, 2, '0', STR_PAD_LEFT) . "/" . str_pad($jd, 2, '0', STR_PAD_LEFT);
    if ($withTime) {
        $time_part = date('H:i:s', $timestamp);
        return $date_part . ' ' . $time_part;
    } else {
        return $date_part;
    }
}
/**
 * ارسال پیام به یک چت خاص
 */
function send_message($chat_id, $text, $reply_markup = null) {
    global $website;
    
    $data = [
        'chat_id'    => $chat_id,
        'text'       => $text,
        'parse_mode' => 'HTML'
    ];
    
    if ($reply_markup) {
        $data['reply_markup'] = json_encode($reply_markup);
    }
    
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL            => $website.'/sendMessage',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => $data
    ]);
    $result = curl_exec($ch);
    curl_close($ch);
    
    return $result;
}

/**
 * ارسال اطلاعیه به همه کاربران
 */
function send_announcement_to_all($message) {
    global $pdo;
    try {
        $stmt = $pdo->query("SELECT chat_id FROM users");
        while ($row = $stmt->fetch()) {
            send_message($row['chat_id'], "📢 اطلاعیه جدید:\n\n$message");
            usleep(300000); // تاخیر 0.3 ثانیه برای جلوگیری از محدودیت تلگرام
        }
    } catch (PDOException $e) {
        file_put_contents('db_errors.log', date('Y-m-d H:i:s').' - '.$e->getMessage().PHP_EOL, FILE_APPEND);
    }
}

/**
 * نمایش لیست اطلاعیه‌های ادمین
 */
function show_announcements_list($chat_id, $admin_id) {
    global $pdo, $keyboards;
    try {
        $stmt = $pdo->prepare("SELECT * FROM announcements WHERE admin_id = ? ORDER BY created_at DESC");
        $stmt->execute([$admin_id]);
        $announcements = $stmt->fetchAll();
        
        if(empty($announcements)) {
            send_message($chat_id, "📭 هیچ اطلاعیه‌ای یافت نشد!");
            return;
        }
        
        $response = "📜 لیست آخرین اطلاعیه‌ها:\n\n";
        foreach($announcements as $ann) {
            $response .= "🆔 شناسه: {$ann['id']}\n";
            $response .= "📅 تاریخ: " . date('Y/m/d H:i', strtotime($ann['created_at'])) . "\n";
            // از mb_substr استفاده کنیم تا در متن فارسی خروجی بهتری داشته باشیم
            $response .= "📝 متن: " . mb_substr($ann['message'], 0, 50) . "...\n";
            $response .= "✏️ ویرایش: /edit_{$ann['id']}\n";
            $response .= "🗑 حذف: /del_{$ann['id']}\n\n";
        }
        
        send_message($chat_id, $response, $keyboards['admin_announce']);
    } catch (PDOException $e) {
        file_put_contents('db_errors.log', date('Y-m-d H:i:s').' - '.$e->getMessage().PHP_EOL, FILE_APPEND);
        send_message($chat_id, "⚠ خطایی در دریافت لیست اطلاعیه‌ها!");
    }
}

/**
 * تولید فایل اکسل لیست شرکت‌کنندگان
 */
function generate_excel()
{
    global $pdo;
    try {
        // ترجیحاً فایل با پسوند CSV برای راحتی باز شدن در Excel
        $filename  = 'participants_'.time().'.csv';
        $file_path = $_SERVER['DOCUMENT_ROOT'].'/downloads/'.$filename;
        
        if(!is_dir(dirname($file_path))) {
            mkdir(dirname($file_path), 0755, true);
        }
        
        $file = fopen($file_path, 'w');
        // BOM UTF-8 برای نمایش صحیح فارسی
        fwrite($file, "\xEF\xBB\xBF");
        
        // هدرها
        $header = ["ردیف", "نام", "شماره تماس", "تاریخ ثبت نام (شمسی)"];
        fputcsv($file, $header, ',');
        
        // داده‌ها را می‌گیریم
        $stmt = $pdo->query("SELECT * FROM users WHERE phone IS NOT NULL ORDER BY registered_at DESC");
        $data = $stmt->fetchAll();
        
        foreach($data as $index => $row) {
            $jalaliDate = '-';
            if (!empty($row['registered_at'])) {
                // اینجا تبدیل به شمسی
                $jalaliDate = to_jalali_datetime($row['registered_at']);
            }
            
            $row_data = [
                $index + 1,
                $row['full_name'] ?: '-',
                $row['phone'],
                $jalaliDate
            ];
            
            fputcsv($file, $row_data, ',');
        }
        
        fclose($file);
        
        // لینک دانلود
        return "https://bot.drbehzadmoghadam.com/downloads/".$filename;
        
    } catch (PDOException $e) {
        file_put_contents('db_errors.log', date('Y-m-d H:i:s').' - '.$e->getMessage().PHP_EOL, FILE_APPEND);
        return false;
    }
}


