<?php
/**
 * این فایل، اصلی‌ترین فایل پروژه است؛
 * آپدیت‌های دریافتی از تلگرام را می‌گیرد و منطق را اجرا می‌کند.
 */

// ابتدا فایل‌های ضروری را وارد می‌کنیم:
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/keyboards.php';
require_once __DIR__ . '/functions.php';

// دریافت ورودی تلگرام
$input = file_get_contents('php://input');
$update = json_decode($input, true);

// ثبت ورودی در لاگ (اختیاری)
file_put_contents('update.log', $input.PHP_EOL, FILE_APPEND);

// استخراج مقادیر ضروری از آپدیت
$chat_id = $update['message']['chat']['id'] ?? null;
$text    = $update['message']['text']       ?? '';
$user_id = $update['message']['from']['id'] ?? null;

// اگر chat_id خالی است (مثلاً آپدیتی غیر از message)، از تابع خارج شویم
if (empty($chat_id)) {
    exit;
}

// 1) بررسی دستور /start
if ($text === '/start') {
    $welcome = "👋 سلام به ربات تلگرامی دکتر بهزاد مقدم خوش آمدید!\n\n"
             . "ارتباط سریع: @btmmk";

    // بررسی ادمین بودن
    $is_admin = in_array($user_id, $admin_ids);
    
    // افزودن کاربر در دیتابیس اگر اولین بار است
    $stmt = $pdo->prepare("INSERT IGNORE INTO users (chat_id, state) VALUES (?, 'main_menu')");
    $stmt->execute([$chat_id]);
    
    // ارسال پیام خوش‌آمد
    send_message($chat_id, $welcome, get_main_keyboard($is_admin));
    exit;
}

// 2) اگر /start نبود، وضعیت کاربر را از جدول users بخوانیم
$stmt = $pdo->prepare("SELECT * FROM users WHERE chat_id = ?");
$stmt->execute([$chat_id]);
$user = $stmt->fetch();

// اگر کاربر در دیتابیس نباشد
if (!$user) {
    send_message($chat_id, "⚠ لطفا ابتدا دستور /start را اجرا کنید!");
    exit;
}

// تشخیص ادمین بودن
$is_admin = in_array($user_id, $admin_ids);

// 3) سوییچ روی متن پیام برای دکمه‌های عمومی
switch($text) {

    case '📱 شبکه های اجتماعی':
        send_message($chat_id, "شبکه های اجتماعی ما:", $keyboards['social']);
        $pdo->prepare("UPDATE users SET state = 'social_menu' WHERE chat_id = ?")->execute([$chat_id]);
        exit;
        break;
        
    case '📝 درباره من':
        send_message($chat_id, $about_text, $keyboards['back']);
        $pdo->prepare("UPDATE users SET state = 'about_menu' WHERE chat_id = ?")->execute([$chat_id]);
        exit;
        break;
        
    // تغییر دکمه از «🎓 شرکت در وبینار» به «📝 درخواست مشاوره»
    case '📝 درخواست مشاوره':
        send_message($chat_id, "لطفا نام خود را وارد کنید:", $keyboards['back']);
        $pdo->prepare("UPDATE users SET state = 'awaiting_name' WHERE chat_id = ?")->execute([$chat_id]);
        exit;
        break;
        
    // ممکن است کاربر روی یکی از دو دکمه «🔙 بازگشت» یا «🔙 بازگشت به منوی اصلی» کلیک کند
    case '🔙 بازگشت':
    case '🔙 بازگشت به منوی اصلی':
        $pdo->prepare("UPDATE users SET state = 'main_menu', temp_data = NULL WHERE chat_id = ?")
            ->execute([$chat_id]);
        send_message($chat_id, "منوی اصلی:", get_main_keyboard($is_admin));
        exit;
        break;
}

// 4) اگر دستورات عمومی نبود، بر اساس state کاربر عمل کنیم
switch($user['state']) {

    // --- منوی شبکه‌های اجتماعی ---
    case 'social_menu':
        if (isset($social_links[$text])) {
            send_message($chat_id, "🔗 لینک $text:\n" . $social_links[$text]);
        }
        break;

    // --- منوی درباره من ---
    case 'about_menu':
        // اگر لازم است پاسخی خاص بدهید، اینجا بنویسید
        break;

    // --- مرحله اول: دریافت نام کاربر ---
    case 'awaiting_name':
        // ذخیره‌ی نام کاربر در ستون full_name
        $pdo->prepare("UPDATE users SET full_name = ?, state = 'awaiting_phone' WHERE chat_id = ?")
            ->execute([$text, $chat_id]);
        
        send_message($chat_id, "لطفا شماره موبایل خود را وارد کنید:", $keyboards['back']);
        break;

    // --- مرحله دوم: دریافت شماره تلفن کاربر ---
    case 'awaiting_phone':
        if (preg_match('/^09[0-9]{9}$/', $text)) {
            // ثبت شماره موبایل
            $pdo->prepare("
            UPDATE users 
            SET phone         = ?, 
                registered_at = NOW(),
                state         = 'main_menu'
            WHERE chat_id     = ?
        ")->execute([$text, $chat_id]);

            // پیام تأیید
            send_message(
                $chat_id,
                "درخواست مشاوره شما برای تیم دکتر مقدم ارسال شد.\nبزودی با شما تماس خواهیم گرفت."
            );

            // بازگشت به منوی اصلی
            send_message($chat_id, "منوی اصلی:", get_main_keyboard($is_admin));

        } else {
            send_message($chat_id, "⚠ شماره نامعتبر! لطفا شماره را به صورت 09123456789 وارد کنید.");
        }
        break;

    // --- بخش‌های مربوط به اطلاعیه‌ها (ادمین) ---
    case 'announce_management':
        // در صورت نیاز به پاسخ خاص در این حالت
        break;

    case 'awaiting_announcement':
        $pdo->prepare("UPDATE users SET temp_data = ?, state = 'confirm_announcement' WHERE chat_id = ?")
            ->execute([$text, $chat_id]);
        send_message($chat_id, "📣 پیش نمایش اطلاعیه:\n\n$text\n\nآیا مایل به ارسال هستید؟", $keyboards['confirm']);
        break;

    case 'confirm_announcement':
        if($text == '✅ تأیید و ارسال') {
            send_announcement_to_all($user['temp_data']);
            $pdo->prepare("INSERT INTO announcements (admin_id, message) VALUES (?, ?)")
               ->execute([$user_id, $user['temp_data']]);
            send_message($chat_id, "✅ اطلاعیه با موفقیت ارسال شد!", get_main_keyboard($is_admin));
            $pdo->prepare("UPDATE users SET state = 'main_menu', temp_data = NULL WHERE chat_id = ?")
                ->execute([$chat_id]);
        } elseif($text == '❌ لغو ارسال') {
            send_message($chat_id, "❌ ارسال اطلاعیه لغو شد!", get_main_keyboard($is_admin));
            $pdo->prepare("UPDATE users SET state = 'main_menu', temp_data = NULL WHERE chat_id = ?")
                ->execute([$chat_id]);
        }
        break;

    case 'editing_announcement':
        $stmt = $pdo->prepare("UPDATE announcements SET message = ? WHERE id = ? AND admin_id = ?");
        $stmt->execute([$text, $user['temp_data'], $user_id]);
        send_message($chat_id, "✅ اطلاعیه با موفقیت ویرایش شد!", $keyboards['admin_announce']);
        $pdo->prepare("UPDATE users SET state = 'announce_management', temp_data = NULL WHERE chat_id = ?")
            ->execute([$chat_id]);
        break;
}

// 5) دستورات مربوط به ادمین
if ($is_admin) {
    switch($text) {
        case '👥 دریافت لیست شرکت کنندگان':
            $file_url = generate_excel();
            send_message($chat_id, "📎 فایل لیست شرکت کنندگان:\n".$file_url, get_main_keyboard(true));
            break;
            
        case '📢 مدیریت اطلاعیه‌ها':
            send_message($chat_id, "منوی مدیریت اطلاعیه‌ها:", $keyboards['admin_announce']);
            $pdo->prepare("UPDATE users SET state = 'announce_management' WHERE chat_id = ?")->execute([$chat_id]);
            break;
            
        case '📢 ارسال اطلاعیه':
            send_message($chat_id, "لطفا متن اطلاعیه را وارد کنید:", $keyboards['back']);
            $pdo->prepare("UPDATE users SET state = 'awaiting_announcement' WHERE chat_id = ?")->execute([$chat_id]);
            break;
            
        case '📋 لیست اطلاعیه‌ها':
            show_announcements_list($chat_id, $user_id);
            break;
    }

    // دستورات ویرایش/حذف اطلاعیه
    if(strpos($text, '/edit_') === 0) {
        $ann_id = str_replace('/edit_', '', $text);
        $pdo->prepare("UPDATE users SET state = 'editing_announcement', temp_data = ? WHERE chat_id = ?")
           ->execute([$ann_id, $chat_id]);
        send_message($chat_id, "لطفا متن جدید را وارد کنید:", $keyboards['back']);
    }
    
    if(strpos($text, '/del_') === 0) {
        $ann_id = str_replace('/del_', '', $text);
        $stmt = $pdo->prepare("DELETE FROM announcements WHERE id = ? AND admin_id = ?");
        $stmt->execute([$ann_id, $user_id]);
        send_message($chat_id, "✅ اطلاعیه با موفقیت حذف شد!", $keyboards['admin_announce']);
    }
}
